/*
 *
 * 2020 Copyright (C) Geotab Inc. All rights reserved.
 */

package com.geotab.model.entity.textmessage;

import lombok.Builder;
import lombok.Data;

/**
 * Text message content including a list of predetermined responses. Derived from {@link TextContent}.
 */
@Data
public class PassthroughEnabledMessage extends DataToComponentContent {

  @Builder(builderMethodName = "passthroughEnabledMessageBuilder")
  public PassthroughEnabledMessage() {
    super(MessageContentType.PASSTHROUGH_ENABLED_MESSAGE, 0, 11, 1, true);
  }
}
