/*
 *
 * 2020 Copyright (C) Geotab Inc. All rights reserved.
 */

package com.geotab.model.entity.textmessage;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.geotab.model.Id;
import com.geotab.model.serialization.ByteArrayDeserializer;
import com.geotab.model.serialization.ByteArraySerializer;
import com.geotab.model.serialization.ListIdConverter;
import java.util.List;
import lombok.Builder;
import lombok.Data;

/**
 * The contents of a {@link TextMessage} that can be used to control the state of an IOX-OUTPUT.
 */
@Data
public class StatusDataRequestContent extends DataToComponentContent {

  /**
   * The Ids to request data from.
   */
  @JsonSerialize(converter = ListIdConverter.class)
  private List<Id> ids;

  @JsonDeserialize(using = ByteArrayDeserializer.class)
  @JsonSerialize(using = ByteArraySerializer.class)
  private Byte[] data;

  @Builder(builderMethodName = "statusDataRequestContentBuilder")
  public StatusDataRequestContent(List<Id> ids, Byte[] data) {
    super(MessageContentType.STATUS_DATA_REQUEST, 0, 4, 0, true);
    this.ids = ids;
    this.data = data;
  }

  public StatusDataRequestContent() {
    super(MessageContentType.STATUS_DATA_REQUEST, 0, 4, 0, true);
  }
}
