/*
 *
 * 2020 Copyright (C) Geotab Inc. All rights reserved.
 */

package com.geotab.model.entity.trailer;

import com.geotab.model.entity.NameEntityWithVersion;
import com.geotab.model.entity.group.Group;
import java.util.List;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.SuperBuilder;

/**
 * A trailer which can be attached and detached from a vehicle with a {@link TrailerAttachment} record.
 */
@Data
@NoArgsConstructor
@SuperBuilder
public class Trailer extends NameEntityWithVersion {

  /**
   * The free text field where any user information can be stored and referenced for this entity. Default [""]
   */
  private String comment;

  /**
   * The list of trailer groups.
   */
  private List<Group> groups;
}
