/*
 *
 * 2020 Copyright (C) Geotab Inc. All rights reserved.
 */

package com.geotab.model.entity.trailer;

import com.geotab.model.entity.EntityWithVersion;
import com.geotab.model.entity.device.Device;
import java.time.LocalDateTime;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.SuperBuilder;

/**
 * A TrailerAttachment is a record of the attachment of a {@link Trailer}  to a {@link Device} over a period of time.
 */
@Data
@NoArgsConstructor
@SuperBuilder
public class TrailerAttachment extends EntityWithVersion {

  /**
   * The date and time the {@link Trailer} was attached.
   */
  private LocalDateTime activeFrom;

  /**
   * The date and time the {@link Trailer} was detached.
   */
  private LocalDateTime activeTo;

  /**
   * Sets the StatusData for the {@link Device} specified.
   */
  private Device device;

  /**
   * The attached {@link Trailer}.
   */
  private Trailer trailer;
}
