/*
 *
 * 2020 Copyright (C) Geotab Inc. All rights reserved.
 */

package com.geotab.model.entity.unitofmeasure;

import lombok.Data;

/**
 * Represents the unit of measure for electric current.
 */
@Data
public final class UnitOfMeasureAmps extends UnitOfMeasureSystem {

  private static class InstanceHolder {

    private static final UnitOfMeasureAmps INSTANCE = new UnitOfMeasureAmps();
  }

  public static final String UNIT_OF_MEASURE_AMPS_ID = "UnitOfMeasureAmpsId";
  public static final String UNIT_OF_MEASURE_AMPS_NAME = "A";

  private UnitOfMeasureAmps() {
    super(UNIT_OF_MEASURE_AMPS_ID, UNIT_OF_MEASURE_AMPS_NAME);
  }

  public static UnitOfMeasureAmps getInstance() {
    return UnitOfMeasureAmps.InstanceHolder.INSTANCE;
  }
}
