/*
 *
 * 2020 Copyright (C) Geotab Inc. All rights reserved.
 */

package com.geotab.model.entity.unitofmeasure;

import lombok.Data;

/**
 * Represents the unit of measure for digital storage.
 */
@Data
public final class UnitOfMeasureBytes extends UnitOfMeasureSystem {

  private static class InstanceHolder {

    private static final UnitOfMeasureBytes INSTANCE = new UnitOfMeasureBytes();
  }

  public static final String UNIT_OF_MEASURE_BYTES_ID = "UnitOfMeasureBytesId";
  public static final String UNIT_OF_MEASURE_BYTES_NAME = "B";

  private UnitOfMeasureBytes() {
    super(UNIT_OF_MEASURE_BYTES_ID, UNIT_OF_MEASURE_BYTES_NAME);
  }

  public static UnitOfMeasureBytes getInstance() {
    return UnitOfMeasureBytes.InstanceHolder.INSTANCE;
  }
}
