/*
 *
 * 2020 Copyright (C) Geotab Inc. All rights reserved.
 */

package com.geotab.model.entity.unitofmeasure;

import lombok.Data;

/**
 * Represents the unit of measure for volumetric flow rate.
 */
@Data
public final class UnitOfMeasureCubicMetersPerSecond extends UnitOfMeasureSystem {

  private static class InstanceHolder {

    private static final UnitOfMeasureCubicMetersPerSecond INSTANCE = new UnitOfMeasureCubicMetersPerSecond();
  }

  public static final String UNIT_OF_MEASURE_CUBIC_METERS_PER_SECOND_ID = "UnitOfMeasureCubicMetersPerSecondId";
  public static final String UNIT_OF_MEASURE_CUBIC_METERS_PER_SECOND_NAME = "m^3/s";

  private UnitOfMeasureCubicMetersPerSecond() {
    super(UNIT_OF_MEASURE_CUBIC_METERS_PER_SECOND_ID, UNIT_OF_MEASURE_CUBIC_METERS_PER_SECOND_NAME);
  }

  public static UnitOfMeasureCubicMetersPerSecond getInstance() {
    return UnitOfMeasureCubicMetersPerSecond.InstanceHolder.INSTANCE;
  }
}
