/*
 *
 * 2020 Copyright (C) Geotab Inc. All rights reserved.
 */

package com.geotab.model.entity.unitofmeasure;

import lombok.Data;

/**
 * Represents the unit of measure for temperature.
 */
@Data
public final class UnitOfMeasureDegreesCelsius extends UnitOfMeasureSystem {

  private static class InstanceHolder {

    private static final UnitOfMeasureDegreesCelsius INSTANCE = new UnitOfMeasureDegreesCelsius();
  }

  public static final String UNIT_OF_MEASURE_DEGREES_CELSIUS_ID = "UnitOfMeasureDegreesCelsiusId";
  public static final String UNIT_OF_MEASURE_DEGREES_CELSIUS_NAME = "C";

  private UnitOfMeasureDegreesCelsius() {
    super(UNIT_OF_MEASURE_DEGREES_CELSIUS_ID, UNIT_OF_MEASURE_DEGREES_CELSIUS_NAME);
  }

  public static UnitOfMeasureDegreesCelsius getInstance() {
    return UnitOfMeasureDegreesCelsius.InstanceHolder.INSTANCE;
  }
}
