/*
 *
 * 2020 Copyright (C) Geotab Inc. All rights reserved.
 */

package com.geotab.model.entity.unitofmeasure;

import lombok.Data;

/**
 * Represents the unit of measure for mass.
 */
@Data
public final class UnitOfMeasureGrams extends UnitOfMeasureSystem {

  private static class InstanceHolder {

    private static final UnitOfMeasureGrams INSTANCE = new UnitOfMeasureGrams();
  }

  public static final String UNIT_OF_MEASURE_GRAMS_ID = "UnitOfMeasureGramsId";
  public static final String UNIT_OF_MEASURE_GRAMS_NAME = "g";

  private UnitOfMeasureGrams() {
    super(UNIT_OF_MEASURE_GRAMS_ID, UNIT_OF_MEASURE_GRAMS_NAME);
  }

  public static UnitOfMeasureGrams getInstance() {
    return UnitOfMeasureGrams.InstanceHolder.INSTANCE;
  }
}
