/*
 *
 * 2020 Copyright (C) Geotab Inc. All rights reserved.
 */

package com.geotab.model.entity.unitofmeasure;

import lombok.Data;

/**
 * Represents the unit of measure an amount of cycles per second.
 */
@Data
public final class UnitOfMeasureHertz extends UnitOfMeasureSystem {

  private static class InstanceHolder {

    private static final UnitOfMeasureHertz INSTANCE = new UnitOfMeasureHertz();
  }

  public static final String UNIT_OF_MEASURE_HERTZ_ID = "UnitOfMeasureHertzId";
  public static final String UNIT_OF_MEASURE_HERTZ_NAME = "Hz";

  private UnitOfMeasureHertz() {
    super(UNIT_OF_MEASURE_HERTZ_ID, UNIT_OF_MEASURE_HERTZ_NAME);
  }

  public static UnitOfMeasureHertz getInstance() {
    return UnitOfMeasureHertz.InstanceHolder.INSTANCE;
  }
}
