/*
 *
 * 2020 Copyright (C) Geotab Inc. All rights reserved.
 */

package com.geotab.model.entity.unitofmeasure;

import lombok.Data;

/**
 * Represents the unit of measure for energy (power * time).
 */
@Data
public final class UnitOfMeasureKiloWattHours extends UnitOfMeasureSystem {

  private static class InstanceHolder {

    private static final UnitOfMeasureKiloWattHours INSTANCE = new UnitOfMeasureKiloWattHours();
  }

  public static final String UNIT_OF_MEASURE_KILO_WATT_HOURS_ID = "UnitOfMeasureKiloWattHoursId";
  public static final String UNIT_OF_MEASURE_KILO_WATT_HOURS_NAME = "kWh";

  private UnitOfMeasureKiloWattHours() {
    super(UNIT_OF_MEASURE_KILO_WATT_HOURS_ID, UNIT_OF_MEASURE_KILO_WATT_HOURS_NAME);
  }

  public static UnitOfMeasureKiloWattHours getInstance() {
    return UnitOfMeasureKiloWattHours.InstanceHolder.INSTANCE;
  }
}
