/*
 *
 * 2020 Copyright (C) Geotab Inc. All rights reserved.
 */

package com.geotab.model.entity.unitofmeasure;

import lombok.Data;

/**
 * Represents the unit of measure for speed.
 */
@Data
public final class UnitOfMeasureKilometersPerHour extends UnitOfMeasureSystem {

  private static class InstanceHolder {

    private static final UnitOfMeasureKilometersPerHour INSTANCE = new UnitOfMeasureKilometersPerHour();
  }

  public static final String UNIT_OF_MEASURE_KILOMETERS_PER_HOUR_ID = "UnitOfMeasureKilometersPerHourId";
  public static final String UNIT_OF_MEASURE_KILOMETERS_PER_HOUR_NAME = "km/h";

  private UnitOfMeasureKilometersPerHour() {
    super(UNIT_OF_MEASURE_KILOMETERS_PER_HOUR_ID, UNIT_OF_MEASURE_KILOMETERS_PER_HOUR_NAME);
  }

  public static UnitOfMeasureKilometersPerHour getInstance() {
    return UnitOfMeasureKilometersPerHour.InstanceHolder.INSTANCE;
  }
}
