/*
 *
 * 2020 Copyright (C) Geotab Inc. All rights reserved.
 */

package com.geotab.model.entity.unitofmeasure;

import lombok.Data;

/**
 * Represents the unit of measure for the ratio of distance to fuel consumption.
 */
@Data
public final class UnitOfMeasureKilometersPerKilogram extends UnitOfMeasureSystem {

  private static class InstanceHolder {

    private static final UnitOfMeasureKilometersPerKilogram INSTANCE = new UnitOfMeasureKilometersPerKilogram();
  }

  public static final String UNIT_OF_MEASURE_KILOMETERS_PER_KILOGRAM_ID = "UnitOfMeasureKilometersPerKilogramId";
  public static final String UNIT_OF_MEASURE_KILOMETERS_PER_KILOGRAM_NAME = "km/kg";

  private UnitOfMeasureKilometersPerKilogram() {
    super(UNIT_OF_MEASURE_KILOMETERS_PER_KILOGRAM_ID, UNIT_OF_MEASURE_KILOMETERS_PER_KILOGRAM_NAME);
  }

  public static UnitOfMeasureKilometersPerKilogram getInstance() {
    return UnitOfMeasureKilometersPerKilogram.InstanceHolder.INSTANCE;
  }
}
