/*
 *
 * 2020 Copyright (C) Geotab Inc. All rights reserved.
 */

package com.geotab.model.entity.unitofmeasure;

import lombok.Data;

/**
 * Represents the unit of measure for distance over volume.
 */
@Data
public final class UnitOfMeasureKilometersPerLiter extends UnitOfMeasureSystem {

  private static class InstanceHolder {

    private static final UnitOfMeasureKilometersPerLiter INSTANCE = new UnitOfMeasureKilometersPerLiter();
  }

  public static final String UNIT_OF_MEASURE_KILOMETERS_PER_LITER_ID = "UnitOfMeasureKilometersPerLiterId";
  public static final String UNIT_OF_MEASURE_KILOMETERS_PER_LITER_NAME = "km/L";

  private UnitOfMeasureKilometersPerLiter() {
    super(UNIT_OF_MEASURE_KILOMETERS_PER_LITER_ID, UNIT_OF_MEASURE_KILOMETERS_PER_LITER_NAME);
  }

  public static UnitOfMeasureKilometersPerLiter getInstance() {
    return UnitOfMeasureKilometersPerLiter.InstanceHolder.INSTANCE;
  }
}
