/*
 *
 * 2020 Copyright (C) Geotab Inc. All rights reserved.
 */

package com.geotab.model.entity.unitofmeasure;

import lombok.Data;

/**
 * Represents the unit of measure for the volume of a liquid.
 */
@Data
public final class UnitOfMeasureLiters extends UnitOfMeasureSystem {

  private static class InstanceHolder {

    private static final UnitOfMeasureLiters INSTANCE = new UnitOfMeasureLiters();
  }

  public static final String UNIT_OF_MEASURE_LITERS_ID = "UnitOfMeasureLitersId";
  public static final String UNIT_OF_MEASURE_LITERS_NAME = "L";

  private UnitOfMeasureLiters() {
    super(UNIT_OF_MEASURE_LITERS_ID, UNIT_OF_MEASURE_LITERS_NAME);
  }

  public static UnitOfMeasureLiters getInstance() {
    return UnitOfMeasureLiters.InstanceHolder.INSTANCE;
  }
}
