/*
 *
 * 2020 Copyright (C) Geotab Inc. All rights reserved.
 */

package com.geotab.model.entity.unitofmeasure;

import lombok.Data;

/**
 * Represents the unit of measure for volume per lane kilometer.
 */
@Data
public final class UnitOfMeasureLitersPerLaneKilometer extends UnitOfMeasureSystem {

  private static class InstanceHolder {

    private static final UnitOfMeasureLitersPerLaneKilometer INSTANCE = new UnitOfMeasureLitersPerLaneKilometer();
  }

  public static final String UNIT_OF_MEASURE_LITERS_PER_LANE_KILOMETER_ID = "UnitOfMeasureLitersPerLaneKilometerId";
  public static final String UNIT_OF_MEASURE_LITERS_PER_LANE_KILOMETER_NAME = "L/lane km";

  private UnitOfMeasureLitersPerLaneKilometer() {
    super(UNIT_OF_MEASURE_LITERS_PER_LANE_KILOMETER_ID, UNIT_OF_MEASURE_LITERS_PER_LANE_KILOMETER_NAME);
  }

  public static UnitOfMeasureLitersPerLaneKilometer getInstance() {
    return UnitOfMeasureLitersPerLaneKilometer.InstanceHolder.INSTANCE;
  }
}
