/*
 *
 * 2020 Copyright (C) Geotab Inc. All rights reserved.
 */

package com.geotab.model.entity.unitofmeasure;

import lombok.Data;

/**
 * Represents the unit of measure for acceleration.
 */
@Data
public final class UnitOfMeasureMetersPerSecondSquared extends UnitOfMeasureSystem {

  private static class InstanceHolder {

    private static final UnitOfMeasureMetersPerSecondSquared INSTANCE = new UnitOfMeasureMetersPerSecondSquared();
  }

  public static final String UNIT_OF_MEASURE_METERS_PER_SECOND_SQUARED_ID = "UnitOfMeasureMetersPerSecondSquaredId";
  public static final String UNIT_OF_MEASURE_METERS_PER_SECOND_SQUARED_NAME = "m/s^2";

  private UnitOfMeasureMetersPerSecondSquared() {
    super(UNIT_OF_MEASURE_METERS_PER_SECOND_SQUARED_ID, UNIT_OF_MEASURE_METERS_PER_SECOND_SQUARED_NAME);
  }

  public static UnitOfMeasureMetersPerSecondSquared getInstance() {
    return UnitOfMeasureMetersPerSecondSquared.InstanceHolder.INSTANCE;
  }
}
