/*
 *
 * 2020 Copyright (C) Geotab Inc. All rights reserved.
 */

package com.geotab.model.entity.unitofmeasure;

import lombok.Data;

/**
 * Represents the unit of measure for acceleration.
 */
@Data
public final class UnitOfMeasureNewtonMeters extends UnitOfMeasureSystem {

  private static class InstanceHolder {

    private static final UnitOfMeasureNewtonMeters INSTANCE = new UnitOfMeasureNewtonMeters();
  }

  public static final String UNIT_OF_MEASURE_NEWTON_METERS_ID = "UnitOfMeasureNewtonMetersId";
  public static final String UNIT_OF_MEASURE_NEWTON_METERS_NAME = "N m";

  private UnitOfMeasureNewtonMeters() {
    super(UNIT_OF_MEASURE_NEWTON_METERS_ID, UNIT_OF_MEASURE_NEWTON_METERS_NAME);
  }

  public static UnitOfMeasureNewtonMeters getInstance() {
    return UnitOfMeasureNewtonMeters.InstanceHolder.INSTANCE;
  }
}
