/*
 *
 * 2020 Copyright (C) Geotab Inc. All rights reserved.
 */

package com.geotab.model.entity.unitofmeasure;

import lombok.Data;

/**
 * Represents the unit of measure for electrical resistance.
 */
@Data
public final class UnitOfMeasureOhms extends UnitOfMeasureSystem {

  private static class InstanceHolder {

    private static final UnitOfMeasureOhms INSTANCE = new UnitOfMeasureOhms();
  }

  public static final String UNIT_OF_MEASURE_OHMS_ID = "UnitOfMeasureOhmsId";
  public static final String UNIT_OF_MEASURE_OHMS_NAME = "Ohm";

  private UnitOfMeasureOhms() {
    super(UNIT_OF_MEASURE_OHMS_ID, UNIT_OF_MEASURE_OHMS_NAME);
  }

  public static UnitOfMeasureOhms getInstance() {
    return UnitOfMeasureOhms.InstanceHolder.INSTANCE;
  }
}
