/*
 *
 * 2020 Copyright (C) Geotab Inc. All rights reserved.
 */

package com.geotab.model.entity.unitofmeasure;

import lombok.Data;

/**
 * Represents the unit of measure for dimensionless quantities.
 */
@Data
public final class UnitOfMeasurePartsPerMillion extends UnitOfMeasureSystem {

  private static class InstanceHolder {

    private static final UnitOfMeasurePartsPerMillion INSTANCE = new UnitOfMeasurePartsPerMillion();
  }

  public static final String UNIT_OF_MEASURE_PARTS_PER_MILLION_ID = "UnitOfMeasurePartsPerMillionId";
  public static final String UNIT_OF_MEASURE_PARTS_PER_MILLION_NAME = "ppm";

  private UnitOfMeasurePartsPerMillion() {
    super(UNIT_OF_MEASURE_PARTS_PER_MILLION_ID, UNIT_OF_MEASURE_PARTS_PER_MILLION_NAME);
  }

  public static UnitOfMeasurePartsPerMillion getInstance() {
    return UnitOfMeasurePartsPerMillion.InstanceHolder.INSTANCE;
  }
}
