/*
 *
 * 2020 Copyright (C) Geotab Inc. All rights reserved.
 */

package com.geotab.model.entity.unitofmeasure;

import lombok.Data;

/**
 * Represents the unit of measure for a percentage.
 */
@Data
public final class UnitOfMeasurePercentage extends UnitOfMeasureSystem {

  private static class InstanceHolder {

    private static final UnitOfMeasurePercentage INSTANCE = new UnitOfMeasurePercentage();
  }

  public static final String UNIT_OF_MEASURE_PERCENTAGE_ID = "UnitOfMeasurePercentageId";
  public static final String UNIT_OF_MEASURE_PERCENTAGE_NAME = "%";

  private UnitOfMeasurePercentage() {
    super(UNIT_OF_MEASURE_PERCENTAGE_ID, UNIT_OF_MEASURE_PERCENTAGE_NAME);
  }

  public static UnitOfMeasurePercentage getInstance() {
    return UnitOfMeasurePercentage.InstanceHolder.INSTANCE;
  }
}
