/*
 *
 * 2020 Copyright (C) Geotab Inc. All rights reserved.
 */

package com.geotab.model.entity.unitofmeasure;

import lombok.Data;

/**
 * Represents the unit of measure for an angle.
 */
@Data
public class UnitOfMeasureRadians extends UnitOfMeasureSystem {

  private static class InstanceHolder {

    private static final UnitOfMeasureRadians INSTANCE = new UnitOfMeasureRadians();
  }

  public static final String UNIT_OF_MEASURE_RADIANS_ID = "UnitOfMeasureRadiansId";
  public static final String UNIT_OF_MEASURE_RADIANS_NAME = "rad";

  private UnitOfMeasureRadians() {
    super(UNIT_OF_MEASURE_RADIANS_ID, UNIT_OF_MEASURE_RADIANS_NAME);
  }

  public static UnitOfMeasureRadians getInstance() {
    return UnitOfMeasureRadians.InstanceHolder.INSTANCE;
  }
}
