/*
 *
 * 2020 Copyright (C) Geotab Inc. All rights reserved.
 */

package com.geotab.model.entity.unitofmeasure;

import lombok.Data;

/**
 * Represents the unit of measure for RPM.
 */
@Data
public final class UnitOfMeasureRevolutionsPerMinute extends UnitOfMeasureSystem {

  private static class InstanceHolder {

    private static final UnitOfMeasureRevolutionsPerMinute INSTANCE = new UnitOfMeasureRevolutionsPerMinute();
  }

  public static final String UNIT_OF_MEASURE_REVOLUTIONS_PER_MINUTE_ID = "UnitOfMeasureRevolutionsPerMinuteId";
  public static final String UNIT_OF_MEASURE_REVOLUTIONS_PER_MINUTE_NAME = "RPM";

  private UnitOfMeasureRevolutionsPerMinute() {
    super(UNIT_OF_MEASURE_REVOLUTIONS_PER_MINUTE_ID, UNIT_OF_MEASURE_REVOLUTIONS_PER_MINUTE_NAME);
  }

  public static UnitOfMeasureRevolutionsPerMinute getInstance() {
    return UnitOfMeasureRevolutionsPerMinute.InstanceHolder.INSTANCE;
  }
}
