/*
 *
 * 2020 Copyright (C) Geotab Inc. All rights reserved.
 */

package com.geotab.model.entity.unitofmeasure;

import lombok.Data;

/**
 * Represents the unit of measure for an amount of time.
 */
@Data
public final class UnitOfMeasureSeconds extends UnitOfMeasureSystem {

  private static class InstanceHolder {

    private static final UnitOfMeasureSeconds INSTANCE = new UnitOfMeasureSeconds();
  }

  public static final String UNIT_OF_MEASURE_SECONDS_ID = "UnitOfMeasureSecondsId";
  public static final String UNIT_OF_MEASURE_SECONDS_NAME = "s";

  private UnitOfMeasureSeconds() {
    super(UNIT_OF_MEASURE_SECONDS_ID, UNIT_OF_MEASURE_SECONDS_NAME);
  }

  public static UnitOfMeasureSeconds getInstance() {
    return UnitOfMeasureSeconds.InstanceHolder.INSTANCE;
  }
}
