/*
 *
 * 2020 Copyright (C) Geotab Inc. All rights reserved.
 */

package com.geotab.model.entity.unitofmeasure;

import com.geotab.model.Id;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * Represents a system supported unit of measure which cannot be changed.
 */
@Data
@NoArgsConstructor
public class UnitOfMeasureSystem extends UnitOfMeasure {

  private static class InstanceHolder {

    private static final UnitOfMeasureSystem INSTANCE = new UnitOfMeasureSystem();
  }

  protected UnitOfMeasureSystem(String id, String name) {
    setId(new Id(id));
    setName(name);
  }

  @Override
  public boolean isSystemEntity() {
    return true;
  }

  public static UnitOfMeasureSystem getInstance() {
    return UnitOfMeasureSystem.InstanceHolder.INSTANCE;
  }
}
