/*
 *
 * 2020 Copyright (C) Geotab Inc. All rights reserved.
 */

package com.geotab.model.entity.user;

import com.fasterxml.jackson.annotation.JsonEnumDefaultValue;
import com.fasterxml.jackson.annotation.JsonValue;
import com.geotab.model.serialization.HasName;
import com.geotab.util.Util;
import lombok.extern.slf4j.Slf4j;

@Slf4j
public enum Currency implements HasName {

  /**
   * None.
   */
  @JsonEnumDefaultValue
  NONE("None"),

  /**
   * Canadian dollar.
   */
  CAD("Cad"),

  /**
   * Hong Kong dollar.
   */
  HKD("Hkd"),

  /**
   * US dollar.
   */
  USD("Usd"),

  /**
   * Australian dollar.
   */
  AUD("Aud"),

  /**
   * Brazilian rea.
   */
  BRL("Brl"),

  /**
   * Chinese yuan renminbi.
   */
  CNY("Cny"),

  /**
   * European dollar.
   */
  EUR("Eur"),

  /**
   * Indian rupee.
   */
  INR("Inr"),

  /**
   * Indonesian rupiah.
   */
  IDR("Idr"),

  /**
   * Japanese yen.
   */
  JPY("Jpy"),

  /**
   * Mexican peso.
   */
  MXN("Mxn"),

  /**
   * New Zealand dollar.
   */
  NZD("Nzd"),

  /**
   * Norwegian krone.
   */
  NOK("Nok"),

  /**
   * Peruvian new sol.
   */
  PEN("Pen"),

  /**
   * Russian rouble.
   */
  RUB("Rub"),

  /**
   * Saudi riyal.
   */
  SAR("Sar"),

  /**
   * Singapore dollar.
   */
  SGD("Sgd"),

  /**
   * South African rand.
   */
  ZAR("Zar"),

  /**
   * South Korean won.
   */
  KRW("Krw"),

  /**
   * Swedish krona.
   */
  SEK("Sek"),

  /**
   * Swiss franc.
   */
  CHF("Chf"),

  /**
   * Taiwanese dollar.
   */
  TWD("Twd"),

  /**
   * Turkish lira.
   */
  TRY("Try"),

  /**
   * Pound sterling.
   */
  GBP("Gbp");

  private final String name;

  Currency(String name) {
    this.name = name;
  }


  @JsonValue
  public String getName() {
    return name;
  }

  public static Currency findOrDefault(String name) {
    if (Util.isEmpty(name)) {
      log.warn("Empty value is not recognized for {} enum; returning default {}",
          Currency.class.getSimpleName(), Currency.NONE);
      return NONE;
    }

    Currency currency = findByName(name);
    if (currency != null) {
      return currency;
    }

    log.warn("{} is not recognized for {} enum; returning default {}",
        name, Currency.class.getSimpleName(), Currency.NONE);
    return NONE;
  }

  public static Currency findByName(String name) {
    if (Util.isEmpty(name)) {
      return null;
    }

    for (Currency currency : values()) {
      if (currency.getName().equalsIgnoreCase(name.trim())) {
        return currency;
      }
    }

    return null;
  }
}

