/*
 *
 * 2020 Copyright (C) Geotab Inc. All rights reserved.
 */

package com.geotab.model.entity.user;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.geotab.model.entity.group.Group;
import com.geotab.model.serialization.EntityCollectionAsIdCollectionSerializer;
import java.util.List;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.SuperBuilder;

/**
 * A driver in the system, and it is derived from {@link User} with key ids and driver groups. If the driver is unknown
 * then the driver is represented by {@link UnknownDriver}.
 */
@Data
@NoArgsConstructor
@SuperBuilder(builderMethodName = "driverBuilder")
@SuppressWarnings("AbbreviationAsWordInName")
public class Driver extends User {

  /**
   * Home groups for the driver.
   */
  @JsonSerialize(converter = EntityCollectionAsIdCollectionSerializer.class)
  private List<Group> driverGroups;

  /**
   * The NFC Key's serial number associated with the driver.
   */
  private List<Key> keys;

  /**
   * Value indicating whether the driver can view their own data.
   */
  @JsonProperty("viewDriversOwnDataOnly")
  private Boolean viewDriversOwnDataOnly;

  /**
   * The driver license province or state of the user. Default [""].
   */
  private String licenseProvince;

  /**
   * The driver license number of the user. Default [""].
   */
  private String licenseNumber;

  {
    this.isDriver = true;
  }

}
