/*
 *
 * 2020 Copyright (C) Geotab Inc. All rights reserved.
 */

package com.geotab.model.entity.user;

import com.fasterxml.jackson.annotation.JsonEnumDefaultValue;
import com.fasterxml.jackson.annotation.JsonValue;
import com.geotab.model.serialization.HasName;

public enum ElectricEnergyEconomyUnit implements HasName {

  /**
   * Fallback when enumeration value is unknown.
   */
  @JsonEnumDefaultValue
  UNKNOWN("Unknown"),

  /**
   * The liters-e per 100 km unit.
   */
  LITERS_E_PER_100_KM("LitersEPer100Km"),

  /**
   * The km per liter-e unit.
   */
  KM_PER_LITERS_E("KmPerLitersE"),

  /**
   * The kilowatt hour per 100 km unit.
   */
  KILOWH_PER_100_KM("KiloWhPer100Km"),

  /**
   * The watt hour per km unit.
   */
  WH_PER_KM("WhPerKm"),

  /**
   * The km per kilowatt hour unit.
   */
  KM_PER_KILO_WH("KmPerKiloWh"),

  /**
   * The miles per gallon-e (US) unit.
   */
  MPG_E_US("MPGEUS"),

  /**
   * The miles per gallon-e (Imperial) unit.
   */
  MPG_E_IMPERIAL("MPGEImperial"),

  /**
   * The kilowatt hour per 100 miles unit.
   */
  KILOWH_PER_100_MILES("KiloWhPer100Miles"),

  KILOWH_PER_KM("KiloWhPerKm"),

  KILOWH_PER_MILE("KiloWhPerMile"),

  /**
   * The watt hour per mile unit.
   */
  WH_PER_MILE("WhPerMile"),

  /**
   * The mile per kilowatt hour unit.
   */
  MILE_PER_KILOWH("MilePerKiloWh");

  private final String name;

  ElectricEnergyEconomyUnit(String name) {
    this.name = name;
  }

  @JsonValue
  public String getName() {
    return name;
  }
}
