/*
 *
 * 2020 Copyright (C) Geotab Inc. All rights reserved.
 */

package com.geotab.model.entity.user;

import com.fasterxml.jackson.annotation.JsonEnumDefaultValue;
import com.fasterxml.jackson.annotation.JsonValue;
import com.geotab.model.serialization.HasName;
import com.geotab.util.Util;
import lombok.extern.slf4j.Slf4j;

@Slf4j
public enum HosRuleSet implements HasName {

  /**
   * No ruleset.
   */
  @JsonEnumDefaultValue
  NONE("None"),

  /**
   * No ruleset Canada.
   */
  NONE_CANADA("NoneCanada"),

  /**
   * The America7 day ruleset.
   */
  AMERICA_7_DAY("America7Day"),

  /**
   * The America7 day ruleset with split sleeper.
   */
  AMERICA_7_DAY_SLEEPER("America7DaySleeper"),

  /**
   * The America7 day big ruleset.
   */
  AMERICA_7_DAY_BIG("America7DayBig"),

  /**
   * The America8 day ruleset.
   */
  AMERICA_8_DAY("America8Day"),

  /**
   * The America8 day ruleset with split sleeper.
   */
  AMERICA_8_DAY_SLEEPER("America8DaySleeper"),

  /**
   * The America8 day big ruleset.
   */
  AMERICA_8_DAY_BIG("America8DayBig"),

  /**
   * The America8 day big ruleset with split sleeper.
   */
  AMERICA_8_DAY_BIG_SLEEPER("America8DayBigSleeper"),

  /**
   * The America7 day passenger ruleset.
   */
  AMERICA_7_DAY_PASSENGER("America7DayPassenger"),

  /**
   * The America8 day passenger ruleset.
   */
  AMERICA_8_DAY_PASSENGER("America8DayPassenger"),

  /**
   * The America 60-hour/7-day short haul ruleset.
   */
  AMERICA_SHORT_HAUL("AmericaShortHaul"),

  /**
   * The America 70-hour/8-day short haul ruleset.
   */
  AMERICA_SHORT_HAUL_8_DAY("AmericaShortHaul8Day"),

  /**
   * The America 60-hour/7-day short haul ruleset 14hr Workday.
   */
  AMERICA_SHORT_HAUL_14_HR_WORKDAY("AmericaShortHaul14hrWorkday"),

  /**
   * The America 70-hour/8-day short haul ruleset 14hr Workday.
   */
  AMERICA_SHORT_HAUL_8_DAY_14_HR_WORKDAY("AmericaShortHaul8Day14hrWorkday"),

  /**
   * The America 60-hour/7-day short haul passenger ruleset.
   */
  AMERICA_SHORT_HAUL_PASSENGER("AmericaShortHaulPassenger"),

  /**
   * The America 70-hour/8-day short haul passenger ruleset.
   */
  AMERICA_SHORT_HAUL_PASSENGER_8_DAY("AmericaShortHaulPassenger8Day"),

  /**
   * The Canada cycle one ruleset.
   */
  CANADA_CYCLE_ONE("CanadaCycleOne"),

  /**
   * The Canada cycle two ruleset.
   */
  CANADA_CYCLE_TWO("CanadaCycleTwo"),

  /**
   * The California Property Intrastate without rest requirement.
   */
  CALIFORNIA_PROPERTY("CaliforniaProperty"),

  /**
   * The California intrastate Flammable Liquid ruleset.
   */
  CALIFORNIA_FLAMMABLE_LIQUID("CaliforniaFlammableLiquid"),

  /**
   * The California intrastate Flammable Liquid ruleset with rest requirement.
   */
  CALIFORNIA_FLAMMABLE_LIQUID_WITH_REST_REQUIREMENT("CaliforniaFlammableLiquidWithRestRequirement"),

  /**
   * The California intrastate School Pupil ruleset.
   */
  CALIFORNIA_SCHOOL_PUPIL("CaliforniaSchoolPupil"),

  /**
   * The California intrastate School Pupil ruleset with rest requirement.
   */
  CALIFORNIA_SCHOOL_PUPIL_WITH_REST_REQUIREMENT("CaliforniaSchoolPupilWithRestRequirement"),

  /**
   * The California intrastate Farm Product ruleset.
   */
  CALIFORNIA_FARM_PRODUCT("CaliforniaFarmProduct"),

  /**
   * The California intrastate Farm Product ruleset with rest requirement.
   */
  CALIFORNIA_FARM_PRODUCT_WITH_REST_REQUIREMENT("CaliforniaFarmProductWithRestRequirement"),

  /**
   * The California passenger intrastate ruleset.
   */
  CALIFORNIA_PASSENGER("CaliforniaPassenger"),

  /**
   * The OilTransport7Day day ruleset.
   */
  OIL_TRANSPORT_7_DAY("OilTransport7Day"),

  /**
   * The OilTransport7Day day ruleset with split sleeper.
   */
  OIL_TRANSPORT_7_DAY_SLEEPER("OilTransport7DaySleeper"),

  /**
   * The oil transport 7-day big ruleset.
   */
  OIL_TRANSPORT_7_DAY_BIG("OilTransport7DayBig"),

  /**
   * The oil transport 7-day day big ruleset with split sleeper.
   */
  OIL_TRANSPORT_7_DAY_BIG_SLEEPER("OilTransport7DayBigSleeper"),

  /**
   * The oil transport 8-day ruleset.
   */
  OIL_TRANSPORT_8_DAY("OilTransport8Day"),

  /**
   * The oil transport 8-day day ruleset with split sleeper.
   */
  OIL_TRANSPORT_8_DAY_SLEEPER("OilTransport8DaySleeper"),

  /**
   * The oil transport 8-day day 16h exemption ruleset.
   */
  OIL_TRANSPORT_8_DAY_BIG("OilTransport8DayBig"),

  /**
   * The oil transport 8-day day 16h exemption ruleset with split sleeper.
   */
  OIL_TRANSPORT_8_DAY_BIG_SLEEPER("OilTransport8DayBigSleeper"),

  /**
   * The oil transport short-haul 60-hour/7-day short haul ruleset.
   */
  OIL_TRANSPORT_SHORT_HAUL("OilTransportShortHaul"),

  /**
   * The oil transport 70-hour/8-day short haul ruleset.
   */
  OIL_TRANSPORT_SHORT_HAUL_8_DAY("OilTransportShortHaul8Day"),

  /**
   * The oil transport short-haul 60-hour/7-day short haul ruleset 14hr Workday.
   */
  OIL_TRANSPORT_SHORT_HAUL_14_HR_WORKDAY("OilTransportShortHaul14hrWorkday"),

  /**
   * The oil transport 70-hour/8-day short haul ruleset 14hr Workday.
   */
  OIL_TRANSPORT_SHORT_HAUL_8_DAY_14_HR_WORKDAY("OilTransportShortHaul8Day14hrWorkday"),

  /**
   * California with OilTransport with rest requirement.
   */
  OIL_TRANSPORT_CALIFORNIA_8_DAY("OilTransportCalifornia8day"),

  /**
   * California with OilWell with rest requirement.
   */
  OIL_WELL_CALIFORNIA_8_DAY("OilWellCalifornia8day"),

  /**
   * California with OilTransport.
   */
  OIL_TRANSPORT_CALIFORNIA_PROPERTY("OilTransportCaliforniaProperty"),

  /**
   * California with OilWell.
   */
  OIL_WELL_CALIFORNIA_PROPERTY("OilWellCaliforniaProperty"),

  /**
   * The OilWell7Day day ruleset.
   */
  OIL_WELL_7_DAY("OilWell7Day"),

  /**
   * The OilWell7DaySleeper day ruleset.
   */
  OIL_WELL_7_DAY_SLEEPER("OilWell7DaySleeper"),

  /**
   * The OilWell7DayBig day ruleset.
   */
  OIL_WELL_7_DAY_BIG("OilWell7DayBig"),

  /**
   * The OilWell7DayBigSleeper day big ruleset.
   */
  OIL_WELL_7_DAY_BIG_SLEEPER("OilWell7DayBigSleeper"),

  /**
   * The OilWell8Day day ruleset.
   */
  OIL_WELL_8_DAY("OilWell8Day"),

  /**
   * The OilWell8DaySleeper day ruleset.
   */
  OIL_WELL_8_DAY_SLEEPER("OilWell8DaySleeper"),

  /**
   * The OilWell8DayBig day big ruleset.
   */
  OIL_WELL_8_DAY_BIG("OilWell8DayBig"),

  /**
   * The OilWell8DayBigSleeper day big ruleset.
   */
  OIL_WELL_8_DAY_BIG_SLEEPER("OilWell8DayBigSleeper"),

  /**
   * The AmericaSalesperson ruleset.
   */
  AMERICA_SALES_PERSON("AmericaSalesperson"),

  /**
   * The AmericaSalespersonNonCdlShortHaul ruleset.
   */
  AMERICA_SALES_PERSON_NON_CDL_SHORT_HAUL("AmericaSalespersonNonCdlShortHaul"),

  /**
   * The AmericaTexas ruleset.
   */
  AMERICA_TEXAS("AmericaTexas"),

  /**
   * The Texas short-haul 60-hour/7-day ruleset.
   */
  AMERICA_TEXAS_SHORT_HAUL("AmericaTexasShortHaul"),

  /**
   * The Texas short-haul 70-hour/8-day ruleset.
   */
  AMERICA_TEXAS_SHORT_HAUL_8_DAY("AmericaTexasShortHaul8Day"),

  /**
   * The Texas oil transport ruleset.
   */
  OIL_TRANSPORT_TEXAS("OilTransportTexas"),

  /**
   * The Texas oil well ruleset.
   */
  OIL_WELL_TEXAS("OilWellTexas"),

  /**
   * The Florida property 7 day intrastate ruleset.
   */
  FLORIDA_7_DAY("Florida7Day"),

  /**
   * The Florida property 8 day intrastate ruleset.
   */
  FLORIDA_8_DAY("Florida8Day"),

  /**
   * The Florida property short-haul 7 day intrastate ruleset.
   */
  FLORIDA_SHORT_HAUL_7_DAY("FloridaShortHaul7Day"),

  /**
   * The Florida property short-haul 8 day intrastate ruleset.
   */
  FLORIDA_SHORT_HAUL_8_DAY("FloridaShortHaul8Day"),

  /**
   * The USA Property 60-hour/7-day without 34-hour reset ruleset.
   */
  AMERICA_7_DAY_NO_34_H("America7DayNo34h"),

  /**
   * The USA Property 60-hour/7-day without 34-hour reset ruleset with split sleeper.
   */
  AMERICA_7_DAY_NO_34_H_SLEEPER("America7DayNo34hSleeper"),

  /**
   * The USA Property 70-hour/8-day without 34-hour reset ruleset.
   */
  AMERICA_8_DAY_NO_34_H("America8DayNo34h"),

  /**
   * The USA Property 70-hour/8-day without 34-hour reset ruleset with split sleeper.
   */
  AMERICA_8_DAY_NO_34_H_SLEEPER("America8DayNo34hSleeper"),

  /**
   * The USA Property Short-haul 60-hour/7-day without 34-hour reset ruleset.
   */
  AMERICA_SHORT_HAUL_NO_34_H("AmericaShortHaulNo34h"),

  /**
   * The USA Property Short-haul 70-hour/8-day without 34-hour reset ruleset.
   */
  AMERICA_SHORT_HAUL_8_DAY_NO_34_H("AmericaShortHaul8DayNo34h"),

  /**
   * The Brazilian Property Short-haul ruleset.
   */
  BRAZIL_SHORT_HAUL("BrazilShortHaul"),

  /**
   * Carrier Exemption ruleset.
   */
  CARRIER_EXEMPTION("CarrierExemption"),

  /**
   * The USA property non-CDL short-haul 150 air-mile for 60-hour/7-day ruleset.
   */
  AMERICA_NON_CDL_SHORT_HAUL_7_DAY("AmericaNonCdlShortHaul7Day"),

  /**
   * The USA property non-CDL short-haul 150 air-mile for 70-hour/8-day ruleset.
   */
  AMERICA_NON_CDL_SHORT_HAUL_8_DAY("AmericaNonCdlShortHaul8Day"),

  /**
   * Washington Intrastate 80-hour/7-day ruleset.
   */
  WASHINGTON_INTRASTATE_7_DAY("WashingtonIntrastate7Day"),

  /**
   * Washington Intrastate 90-hour/8-day ruleset.
   */
  WASHINGTON_INTRASTATE_8_DAY("WashingtonIntrastate8Day"),

  /**
   * USA Property Without 30Mins Rest Requirement 60-hour/7-day.
   */
  AMERICA_NO_REST_REQUIREMENT_7_DAY("AmericaNoRestRequirement7Day"),

  /**
   * USA Property Without 30Mins Rest Requirement 60-hour/7-day with split sleeper.
   */
  AMERICA_NO_REST_REQUIREMENT_7_DAY_SLEEPER("AmericaNoRestRequirement7DaySleeper"),

  /**
   * USA Property Without 30Mins Rest Requirement 60-hour/7-day (16-hour exemption).
   */
  AMERICA_NO_REST_REQUIREMENT_7_DAY_BIG("AmericaNoRestRequirement7DayBig"),

  /**
   * "USA Property Without 30Mins Rest Requirement 60-hour/7-day (16-hour exemption) with split sleeper.
   */
  AMERICA_NO_REST_REQUIREMENT_7_DAY_BIG_SLEEPER("AmericaNoRestRequirement7DayBigSleeper"),

  /**
   * USA Property Without 30Mins Rest Requirement 70-hour/8-day.
   */
  AMERICA_NO_REST_REQUIREMENT_8_DAY("AmericaNoRestRequirement8Day"),

  /**
   * USA Property Without 30Mins Rest Requirement 70-hour/8-day with split sleeper.
   */
  AMERICA_NO_REST_REQUIREMENT_8_DAY_SLEEPER("AmericaNoRestRequirement8DaySleeper"),

  /**
   * USA Property Without 30Mins Rest Requirement 70-hour/8-day (16-hour exemption).
   */
  AMERICA_NO_REST_REQUIREMENT_8_DAY_BIG("AmericaNoRestRequirement8DayBig"),

  /**
   * USA Property Without 30Mins Rest Requirement 70-hour/8-day (16-hour exemption) with split sleeper.
   */
  AMERICA_NO_REST_REQUIREMENT_8_DAY_BIG_SLEEPER("AmericaNoRestRequirement8DayBigSleeper"),

  /**
   * USA Property Without 30Mins Rest Requirement 60-hour/7-day with 24 hour reset.
   */
  OIL_TRANSPORT_NO_REST_REQUIREMENT_7_DAY("OilTransportNoRestRequirement7Day"),

  /**
   * USA Property Without 30Mins Rest Requirement 60-hour/7-day with 24 hour reset and split sleeper.
   */
  OIL_TRANSPORT_NO_REST_REQUIREMENT_7_DAY_SLEEPER("OilTransportNoRestRequirement7DaySleeper"),

  /**
   * USA Property Without 30Mins Rest Requirement 60-hour/7-day (16-hour exemption) with 24 hour reset.
   */
  OIL_TRANSPORT_NO_REST_REQUIREMENT_7_DAY_BIG("OilTransportNoRestRequirement7DayBig"),

  /**
   * "USA Property Without 30Mins Rest Requirement 60-hour/7-day (16-hour exemption) with 24 hour reset and split
   * sleeper.
   */
  OIL_TRANSPORT_NO_REST_REQUIREMENT_7_DAY_BIG_SLEEPER("OilTransportNoRestRequirement7DayBigSleeper"),

  /**
   * USA Property Without 30Mins Rest Requirement 70-hour/8-day with 24 hour reset.
   */
  OIL_TRANSPORT_NO_REST_REQUIREMENT_8_DAY("OilTransportNoRestRequirement8Day"),

  /**
   * USA Property Without 30Mins Rest Requirement 70-hour/8-day with 24 hour reset and split sleeper.
   */
  OIL_TRANSPORT_NO_REST_REQUIREMENT_8_DAY_SLEEPER("OilTransportNoRestRequirement8DaySleeper"),

  /**
   * USA Property Without 30Mins Rest Requirement 70-hour/8-day (16-hour exemption) with 24 hour reset.
   */
  OIL_TRANSPORT_NO_REST_REQUIREMENT_8_DAY_BIG("OilTransportNoRestRequirement8DayBig"),

  /**
   * USA Property Without 30Mins Rest Requirement 70-hour/8-day (16-hour exemption) with 24 hour reset and split
   * sleeper.
   */
  OIL_TRANSPORT_NO_REST_REQUIREMENT_8_DAY_BIG_SLEEPER("OilTransportNoRestRequirement8DayBigSleeper"),

  /**
   * USA Property Without 30Mins Rest Requirement 60-hour/7-day with 24 hour reset and oil well.
   */
  OIL_WELL_NO_REST_REQUIREMENT_7_DAY("OilWellNoRestRequirement7Day"),

  /**
   * USA Property Without 30Mins Rest Requirement 60-hour/7-day with 24 hour reset and oil well and split sleeper.
   */
  OIL_WELL_NO_REST_REQUIREMENT_7_DAY_SLEEPER("OilWellNoRestRequirement7DaySleeper"),

  /**
   * USA Property Without 30Mins Rest Requirement 60-hour/7-day (16-hour exemption) with 24 hour reset and oil well.
   */
  OIL_WELL_NO_REST_REQUIREMENT_7_DAY_BIG("OilWellNoRestRequirement7DayBig"),

  /**
   * "USA Property Without 30Mins Rest Requirement 60-hour/7-day (16-hour exemption) with 24 hour reset and oil well and
   * split sleeper.
   */
  OIL_WELL_NO_REST_REQUIREMENT_7_DAY_BIG_SLEEPER("OilWellNoRestRequirement7DayBigSleeper"),

  /**
   * USA Property Without 30Mins Rest Requirement 70-hour/8-day with 24 hour reset and oil well.
   */
  OIL_WELL_NO_REST_REQUIREMENT_8_DAY("OilWellNoRestRequirement8Day"),

  /**
   * USA Property Without 30Mins Rest Requirement 70-hour/8-day with 24 hour reset and oil well and split sleeper.
   */
  OIL_WELL_NO_REST_REQUIREMENT_8_DAY_SLEEPER("OilWellNoRestRequirement8DaySleeper"),

  /**
   * USA Property Without 30Mins Rest Requirement 70-hour/8-day (16-hour exemption) with 24 hour reset and oil well.
   */
  OIL_WELL_NO_REST_REQUIREMENT_8_DAY_BIG("OilWellNoRestRequirement8DayBig"),

  /**
   * USA Property Without 30Mins Rest Requirement 70-hour/8-day (16-hour exemption) with 24 hour reset and oil well and
   * split sleeper.
   */
  OIL_WELL_NO_REST_REQUIREMENT_8_DAY_BIG_SLEEPER("OilWellNoRestRequirement8DayBigSleeper"),

  /**
   * North Dakota 70-hour/7-day.
   */
  NORTH_DAKOTA_7_DAY("NorthDakota7Day"),

  /**
   * South Carolina 70-hour/7-day.
   */
  SOUTH_CAROLINA_7_DAY("SouthCarolina7Day"),

  /**
   * South Carolina 80-hour/8-day.
   */
  SOUTH_CAROLINA_8_DAY("SouthCarolina8Day"),

  /**
   * Maryland Short Haul 70-hour/7-day.
   */
  MARYLAND_SHORT_HAUL_7_DAY("MarylandShortHaul7Day"),

  /**
   * Maryland Short Haul 80-hour/8-day.
   */
  MARYLAND_SHORT_HAUL_8_DAY("MarylandShortHaul8Day"),

  /**
   * North Dakota Short Haul 70-hour/7-day.
   */
  NORTH_DAKOTA_SHORT_HAUL_7_DAY("NorthDakotaShortHaul7Day"),

  /**
   * Alaska Passenger 70-hour/7-day.
   */
  ALASKA_PASSENGER_7_DAY("AlaskaPassenger7Day"),

  /**
   * Alaska Passenger 80-hour/8-day.
   */
  ALASKA_PASSENGER_8_DAY("AlaskaPassenger8Day"),

  /**
   * Alaska Property 70-hour/7-day.
   */
  ALASKA_PROPERTY_7_DAY("AlaskaProperty7Day"),

  /**
   * Alaska Property 80-hour/8-day.
   */
  ALASKA_PROPERTY_8_DAY("AlaskaProperty8Day"),

  /**
   * Nebraska 70-hour/7-day.
   */
  NEBRASKA_7_DAY("Nebraska7day"),

  /**
   * Nebraska 80-hour/8-day.
   */
  NEBRASKA_8_DAY("Nebraska8day"),

  /**
   * California Property Intrastate.
   */
  CALIFORNIA_8_DAY("California8day"),

  /**
   * Oregon 70-hour/7-day.
   */
  OREGON_7_DAY("Oregon7day"),

  /**
   * Oregon 80-hour/8-day.
   */
  OREGON_8_DAY("Oregon8day"),

  /**
   * No ruleset 8 day.
   */
  NONE_8_DAY("None8Day"),

  /**
   * The Canada cycle one team ruleset.
   */
  CANADA_CYCLE_ONE_TEAM("CanadaCycleOneTeam"),

  /**
   * The Canada cycle two team ruleset.
   */
  CANADA_CYCLE_TWO_TEAM("CanadaCycleTwoTeam"),

  /**
   * The Canada North of 60 cycle one ruleset.
   */
  CANADA_NORTH_OF_60_CYCLE_ONE("CanadaNorthOf60CycleOne"),

  /**
   * The Canada North of 60 cycle two ruleset.
   */
  CANADA_NORTH_OF_60_CYCLE_TWO("CanadaNorthOf60CycleTwo"),

  /**
   * No ruleset Canada (North of 60).
   */
  NONE_CANADA_NORTH_OF_60("NoneCanadaNorthOf60"),

  /**
   * Australia Standard Hours Solo with Exemption Hour.
   */
  AUSTRALIA_STANDARD_HOURS_SOLO_EXEMPTION_HOURS("AustraliaStandardHoursSoloExemptionHours"),

  ALASKA_PROPERTY_7_DAY_SLEEPER("AlaskaProperty7DaySleeper"),

  ALASKA_PROPERTY_8_DAY_SLEEPER("AlaskaProperty8DaySleeper"),

  AMERICA_7_DAY_BIG_SLEEPER("America7DayBigSleeper"),

  AMERICA_7_DAY_RAILROAD("America7DayRailroad"),

  AMERICA_8_DAY_RAILROAD("America8DayRailroad"),

  CALIFORNIA_PROPERTY_SHORT_HAUL("CaliforniaPropertyShortHaul"),

  CALIFORNIA_PROPERTY_SHORT_HAUL_WITH_REST("CaliforniaPropertyShortHaulWithRest"),

  CANADA_NORTH_OF_60_CYCLE_ONE_TEAM("CanadaNorthOf60CycleOneTeam"),

  CANADA_NORTH_OF_60_CYCLE_TWO_TEAM("CanadaNorthOf60CycleTwoTeam"),

  CANADA_NORTH_OF_60_OIL("CanadaNorthOf60Oil"),

  CANADA_NORTH_OF_60_OIL_TEAM("CanadaNorthOf60OilTeam"),

  CANADA_OIL("CanadaOil"),

  CANADA_OIL_TEAM("CanadaOilTeam");

  private final String name;

  HosRuleSet(String name) {
    this.name = name;
  }

  @JsonValue
  public String getName() {
    return name;
  }

  public static HosRuleSet findOrDefault(String name) {
    if (Util.isEmpty(name)) {
      log.warn("Empty value is not recognized for {} enum; returning default {}",
          HosRuleSet.class.getSimpleName(), HosRuleSet.NONE);
      return NONE;
    }

    for (HosRuleSet hosRuleSet : values()) {
      if (hosRuleSet.getName().equalsIgnoreCase(name.trim())) {
        return hosRuleSet;
      }
    }

    log.warn("{} is not recognized for {} enum; returning default {}",
        name, HosRuleSet.class.getSimpleName(), HosRuleSet.NONE);
    return NONE;
  }
}
