/*
 *
 * 2020 Copyright (C) Geotab Inc. All rights reserved.
 */

package com.geotab.model.entity.user;

import com.geotab.model.Id;
import com.geotab.model.serialization.SystemEntitySerializationAware;
import lombok.Data;

/**
 * A {@link User} that is used when no user specific user is assigned to objects, eg. Notifications.
 */
@Data
public final class NoUser extends User implements SystemEntitySerializationAware {

  private static class InstanceHolder {

    private static final NoUser INSTANCE = new NoUser();
  }

  public static final String NO_USER_ID = "NoUserId";

  private NoUser() {
    setId(new Id(NO_USER_ID));
    setName("**<No User>");
    setVersion(0L);
  }

  @Override
  public boolean isSystemEntity() {
    return true;
  }

  public static NoUser getInstance() {
    return InstanceHolder.INSTANCE;
  }
}
