/*
 *
 * 2020 Copyright (C) Geotab Inc. All rights reserved.
 */

package com.geotab.model.entity.user;

import com.geotab.model.Id;
import com.geotab.model.serialization.SystemEntitySerializationAware;
import lombok.Data;

/**
 * The default unknown driver of a {@link com.geotab.model.entity.device.Device}. Used if the driver is not identified
 * through a key.
 */
@Data
public final class UnknownDriver extends Driver implements SystemEntitySerializationAware {

  private static class InstanceHolder {

    private static final UnknownDriver INSTANCE = new UnknownDriver();
  }

  public static final String UNKNOWN_DRIVER_ID = "UnknownDriverId";

  private UnknownDriver() {
    setId(new Id(UNKNOWN_DRIVER_ID));
    setName("**UnknownDriver");
    setVersion(0L);
  }

  public static UnknownDriver getInstance() {
    return InstanceHolder.INSTANCE;
  }

  @Override
  public boolean isSystemEntity() {
    return true;
  }
}
