package com.geotab.model.entity.user;

import com.fasterxml.jackson.annotation.JsonEnumDefaultValue;
import com.fasterxml.jackson.annotation.JsonValue;
import com.geotab.model.serialization.HasName;

public enum ZoneDisplayMode implements HasName {

  /**
   * Fallback when enumeration value is unknown.
   */
  @JsonEnumDefaultValue
  UNKNOWN("Unknown", -1),

  /**
   * Do not show zones on the map.
   */
  NONE("None", 0),

  /**
   * Always show zones on the map.
   */
  ALL("All", 1),

  /**
   * Use Zone's "displayed" property to determine whether to show the zone on the map.
   */
  DEFAULT("Default", 2);

  private final String name;
  private final int code;

  ZoneDisplayMode(String name, int code) {
    this.name = name;
    this.code = code;
  }

  public int getCode() {
    return code;
  }

  @JsonValue
  public String getName() {
    return name;
  }
}
