/*
 *
 * 2020 Copyright (C) Geotab Inc. All rights reserved.
 */

package com.geotab.model.entity.workholiday;

import com.geotab.model.entity.NameEntity;
import com.geotab.model.entity.worktime.WorkTimeHolidayGroupId;
import java.time.LocalDateTime;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.SuperBuilder;

/**
 * Day that is specified as not being a regular working day.
 */
@Data
@NoArgsConstructor
@SuperBuilder
public class WorkHoliday extends NameEntity {

  /**
   * The midnight of the work holiday.
   */
  private LocalDateTime date;

  /**
   * The holiday group Id.
   */
  private WorkTimeHolidayGroupId holidayGroup;
}
