package com.geotab.model.entity.worktime;

import com.fasterxml.jackson.annotation.JsonEnumDefaultValue;
import com.fasterxml.jackson.annotation.JsonValue;
import com.geotab.model.serialization.HasName;

public enum DayOfWeek implements HasName {

  /**
   * Fallback when enumeration value is unknown.
   */
  @JsonEnumDefaultValue
  UNKNOWN("Unknown"),

  SUNDAY("Sunday"),

  MONDAY("Monday"),

  TUESDAY("Tuesday"),

  WEDNESDAY("Wednesday"),

  THURSDAY("Thursday"),

  FRIDAY("Friday"),

  SATURDAY("Saturday");

  private final String name;

  DayOfWeek(String name) {
    this.name = name;
  }

  @JsonValue
  public String getName() {
    return name;
  }
}
