package com.geotab.model.entity.worktime;

import static com.geotab.model.entity.worktime.WorkTimeAllHours.WORK_TIME_ALL_HOURS_ID;
import static com.geotab.model.entity.worktime.WorkTimeEarlyLeaveHours.WORK_TIME_EARLY_LEAVE_HOURS_ID;
import static com.geotab.model.entity.worktime.WorkTimeLateArrivalHours.WORK_TIME_LATE_ARRIVAL_HOURS_ID;
import static com.geotab.model.entity.worktime.WorkTimeLunchHours.WORK_TIME_LUNCH_HOURS_ID;
import static com.geotab.model.entity.worktime.WorkTimeStandardHours.WORK_TIME_STANDARD_HOURS_ID;

import com.geotab.model.Id;
import com.geotab.model.entity.NameEntity;
import com.geotab.util.Util;
import java.util.List;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.SuperBuilder;

/**
 * The {@link WorkTimeDetail}(s) defining periods during the week that are considered as part of regular working hours.
 * Work times that apply to all times are represented by {@link WorkTimeAllHours}.
 */
@Data
@NoArgsConstructor
@SuperBuilder
public class WorkTime extends NameEntity {

  /**
   * Free text field where any user information can be stored and referenced for this entity. Default [""].
   */
  protected String comment;

  /**
   * The list of {@link WorkTimeDetail}(s).
   */
  protected List<WorkTimeDetail> details;

  /**
   * The {@link WorkTimeHolidayGroupId}.
   */
  protected WorkTimeHolidayGroupId holidayGroup;

  public WorkTime(String id) {
    setId(new Id(id));
    setName(id);
  }

  public static WorkTime fromSystem(String id) {
    if (Util.isEmpty(id)) return null;
    switch (id) {
      case WORK_TIME_ALL_HOURS_ID:
        return WorkTimeAllHours.getInstance();
      case WORK_TIME_STANDARD_HOURS_ID:
        return new WorkTimeStandardHours();
      case WORK_TIME_LUNCH_HOURS_ID:
        return new WorkTimeLunchHours();
      case WORK_TIME_EARLY_LEAVE_HOURS_ID:
        return new WorkTimeEarlyLeaveHours();
      case WORK_TIME_LATE_ARRIVAL_HOURS_ID:
        return new WorkTimeLateArrivalHours();
      default:
        return null;
    }
  }
}
