package com.geotab.model.entity.worktime;

import com.geotab.model.Id;
import java.time.Duration;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Data;

@Data
public final class WorkTimeAllHours extends WorkTimeSystem {

  private static class InstanceHolder {

    private static final WorkTimeAllHours INSTANCE = new WorkTimeAllHours();
  }

  public static final String WORK_TIME_ALL_HOURS_ID = "WorkTimeAllHoursId";

  private WorkTimeAllHours() {
    setId(new Id(WORK_TIME_ALL_HOURS_ID));
    setName("**All Hours");
    setDetails(Stream.of(DayOfWeek.values())
        .map(o -> new WorkTimeDetail().setDayOfWeek(o)
            .setFromTime(Duration.ofMillis(WorkTimeDetail.MIN_VALUE))
            .setToTime(Duration.ofMillis(WorkTimeDetail.MAX_VALUE)))
        .collect(Collectors.toList()));
  }

  public static WorkTimeAllHours getInstance() {
    return InstanceHolder.INSTANCE;
  }
}
