/*
 *
 * 2020 Copyright (C) Geotab Inc. All rights reserved.
 */

package com.geotab.model.entity.zone.type;

import com.geotab.model.Id;
import lombok.Data;

/**
 * A zone type that is for address lookup.
 */
@Data
public class ZoneTypeAddressLookup extends ZoneTypeSystem {

  private static class InstanceHolder {

    private static final ZoneTypeAddressLookup INSTANCE = new ZoneTypeAddressLookup();
  }

  public static final String ZONE_TYPE_ADDRESS_LOOKUP_ID = "ZoneTypeAddressLookupId";

  public ZoneTypeAddressLookup() {
    setId(new Id(ZONE_TYPE_ADDRESS_LOOKUP_ID));
    setName("**Address Lookup Zone");
    setComment("");
  }

  public static ZoneTypeAddressLookup getInstance() {
    return ZoneTypeAddressLookup.InstanceHolder.INSTANCE;
  }
}
