/*
 *
 * 2020 Copyright (C) Geotab Inc. All rights reserved.
 */

package com.geotab.model.entity.zone.type;

import com.geotab.model.Id;
import lombok.Data;

/**
 * A zone type that is a home zone.
 */
@Data
public class ZoneTypeHome extends ZoneTypeSystem {

  private static class InstanceHolder {

    private static final ZoneTypeHome INSTANCE = new ZoneTypeHome();
  }

  public static final String ZONE_TYPE_HOME_ID = "ZoneTypeHomeId";

  public ZoneTypeHome() {
    setId(new Id(ZONE_TYPE_HOME_ID));
    setName("**Home Zone");
    setComment("");
  }

  public static ZoneTypeHome getInstance() {
    return ZoneTypeHome.InstanceHolder.INSTANCE;
  }
}
