/*
 *
 * 2020 Copyright (C) Geotab Inc. All rights reserved.
 */

package com.geotab.model.login;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * The results of an authentication attempt.
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
@Builder
public class LoginResult {

  /**
   * Gets or sets the credentials to be used when making calls to MyGeotab.
   */
  private Credentials credentials;

  /**
   * Gets or sets the path of server hosting the database. "ThisServer" if successfully logged in to this server, or
   * "servername". The caller must handle prepending the protocol.
   */
  private String path;

  @Override
  public String toString() {
    return path;
  }
}
