package com.geotab.model.search;

import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * The object used to specify the arguments when searching for <see cref="AddInConfiguration"/>.
 */
@Data
@NoArgsConstructor
public class AddInConfigurationSearch extends IdSearch {
  /**
   * Gets or sets the name of this Add-In.
   */
  private String name;

  /**
   * Gets or sets the email address for support related to this Add-In.
   */
  private String supportEmail;

  @Builder
  public AddInConfigurationSearch(String id, String name, String supportEmail) {
    super(id);
    this.name = name;
    this.supportEmail = supportEmail;
  }
}
