package com.geotab.model.search;

import com.geotab.model.entity.addins.AddInDeviceLink;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * The object used to specify the arguments when searching for {@link AddInDeviceLink}.
 */
@Data
@NoArgsConstructor
public class AddInDeviceLinkSearch extends IdSearch {
  /**
   * Gets or sets the filter by the {@link AddInSearch} options.
   */
  public AddInSearch addInSearch;

  /**
   * Gets or sets the filter by the {@link DeviceSearch} options.
   */
  public DeviceSearch deviceSearch;

  @Builder
  public AddInDeviceLinkSearch(String id, AddInSearch addInSearch, DeviceSearch deviceSearch) {
    super(id);
    this.addInSearch = addInSearch;
    this.deviceSearch = deviceSearch;
  }
}
