package com.geotab.model.search;

import com.geotab.model.entity.addins.AddIn;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * The object used to specify the arguments when searching for {@link AddIn}.
 */
@Data
@NoArgsConstructor
public class AddInSearch extends IdSearch {

  /**
   * Gets or sets the {@link AddInConfigurationSearch}.
   */
  private AddInConfigurationSearch configuration;

  /**
   * Gets or sets the solution id related to this Add-In.
   */
  private String solutionId;

  @Builder
  public AddInSearch(String id, AddInConfigurationSearch addInConfigurationSearch, String solutionId) {
    super(id);
    this.configuration = addInConfigurationSearch;
    this.solutionId = solutionId;
  }
}
