package com.geotab.model.search;

import com.geotab.model.entity.charging.ChargeEvent;
import lombok.Builder;
import lombok.Data;

@Data
public class ChargeEventSearch extends IdSearch {

  /**
   * Search for {@link ChargeEvent} with this DeviceSearch Id
   *
   * <p>Available DeviceSearch options are:.
   * <ul>
   *    <li>id</li>
   *    <li>group</li>
   * </ul>
   */
  private DeviceSearch deviceSearch;

  /**
   * The object used to specify the arguments when searching for {@link ChargeEvent}(s).
   *
   * <p>Gets or sets filter by the {@link DeviceSearch} options. Providing a device ID will
   * search for any ChargeEvents that are assigned to that Device.
   * Providing the Groups will search for ChargeEvents for that have Devices in that group.
   * Available DeviceSearch options are:
   * <ul>
   *      <li>
   *             Id
   *     </li>
   *      <li>
   *             DeviceSearch + FromDate and/or ToDate (+ IncludeOverlappedTrips)
   *     </li>
   *      <li>
   *             UserSearch + FromDate and/or ToDate (+ IncludeOverlappedTrips)
   *     </li>
   * </ul>
   */
  @Builder
  public ChargeEventSearch(String id, DeviceSearch deviceSearch) {
    super(id);
    this.deviceSearch = deviceSearch;
  }
}
