/*
 *
 * 2020 Copyright (C) Geotab Inc. All rights reserved.
 */

package com.geotab.model.search;

import com.geotab.model.entity.customdata.CustomData;
import java.time.LocalDateTime;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * The object used to specify the arguments when searching for {@link CustomData}(s).
 */
@Data
@NoArgsConstructor
public class CustomDataSearch extends IdSearch {

  /**
   * Search for {@link CustomData} that was recorded at this date or after.
   */
  private LocalDateTime fromDate;

  /**
   * Search for {@link CustomData} that was recorded at this date or before.
   */
  private LocalDateTime toDate;

  /**
   * Search for {@link CustomData} recorded for this {@link DeviceSearch} Id.
   *
   * <p>Available {@link DeviceSearch} options are:
   *  <ul>
   *     <li>
   *         id
   *     </li>
   * </ul>
   */
  private DeviceSearch deviceSearch;

  @Builder
  public CustomDataSearch(String id, LocalDateTime fromDate, LocalDateTime toDate,
      DeviceSearch deviceSearch) {
    super(id);
    this.fromDate = fromDate;
    this.toDate = toDate;
    this.deviceSearch = deviceSearch;
  }
}
