/*
 *
 * 2020 Copyright (C) Geotab Inc. All rights reserved.
 */

package com.geotab.model.search;

import com.geotab.model.entity.debugdata.DebugData;
import java.time.LocalDateTime;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * The object used to specify the arguments when searching for {@link DebugData}(s).
 */
@Data
@NoArgsConstructor
public class DebugDataSearch extends IdSearch {

  /**
   * The search for DebugData recorded for this DeviceSearch Id.
   *
   * <p>Available DeviceSearch options are:
   * <ul>
   *    <li>Id</li>
   * </ul>
   */
  private DeviceSearch deviceSearch;

  /**
   * The date after which DebugData was recorded.
   */
  private LocalDateTime fromDate;

  /**
   * The date before which DebugData was recorded.
   */
  private LocalDateTime toDate;

  @Builder
  public DebugDataSearch(String id, DeviceSearch deviceSearch, LocalDateTime fromDate,
      LocalDateTime toDate) {
    super(id);
    this.deviceSearch = deviceSearch;
    this.fromDate = fromDate;
    this.toDate = toDate;
  }
}
