/*
 *
 * 2020 Copyright (C) Geotab Inc. All rights reserved.
 */

package com.geotab.model.search;

import com.geotab.model.Id;
import com.geotab.model.entity.diagnostic.DiagnosticType;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * The object used to specify the arguments when searching for  {@link com.geotab.model.entity.diagnostic.Diagnostic}s.
 */
@Data
@NoArgsConstructor
public class DiagnosticSearch extends IdSearch {

  /**
   * Search for a Diagnostic by the code number.
   */
  private Integer code;

  /**
   * Search for {@link com.geotab.model.entity.diagnostic.Diagnostic}(s) with this EngineTypeSearchId.
   *
   * <p>Available EngineTypeSearch options are:
   *  <ul>
   *     <li>
   *         {@link Id}
   *     </li>
   * </ul>
   */
  private IdSearch engineTypeSearch;

  /**
   * Search for Diagnostics with this Name. Wildcard can be used by prepending/appending "%" to string. Example
   * "%name%".
   */
  private String name;

  /**
   * Search for {@link com.geotab.model.entity.diagnostic.Diagnostic}(s) with this Source id.
   *
   * <p>Available SourceSearch options are:
   *  <ul>
   *     <li>
   *         {@link Id}
   *     </li>
   * </ul>
   */
  private IdSearch sourceSearch;

  /**
   * The {@link DiagnosticType} to search for in Diagnostics.
   */
  private DiagnosticType diagnosticType;

  @Builder
  public DiagnosticSearch(String id, Integer code, IdSearch engineTypeSearch, String name,
      IdSearch sourceSearch, DiagnosticType diagnosticType) {
    super(id);
    this.code = code;
    this.engineTypeSearch = engineTypeSearch;
    this.name = name;
    this.sourceSearch = sourceSearch;
    this.diagnosticType = diagnosticType;
  }
}
