/*
 *
 * 2020 Copyright (C) Geotab Inc. All rights reserved.
 */

package com.geotab.model.search;

import com.geotab.model.entity.dutystatus.DutyStatusAvailability;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * The object used to specify the arguments when searching for  {@link DutyStatusAvailability}.
 *
 * <p>This search has been designed to work efficiently with a UserSearch.
 */
@Data
@NoArgsConstructor
public class DutyStatusAvailabilitySearch implements Search {

  /**
   * Search for {@link DutyStatusAvailability} with this UserSearch Id or in the provided Groups
   *
   * <p>Available UserSearch options are:.
   * <ul>
   *    <li>Id</li>
   *    <li>DriverGroups</li>
   *    <li>DriverGroupListSearch</li>
   * </ul>
   */
  private UserSearch userSearch;

  @Builder
  public DutyStatusAvailabilitySearch(UserSearch userSearch) {
    this.userSearch = userSearch;
  }
}
