/*
 *
 * 2020 Copyright (C) Geotab Inc. All rights reserved.
 */

package com.geotab.model.search;

import com.geotab.model.entity.dutystatus.DutyStatusLog;
import com.geotab.model.entity.dutystatus.DutyStatusLogType;
import java.time.LocalDateTime;
import java.util.List;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * The object used to specify the arguments when searching for {@link DutyStatusLog}(s).
 */
@Data
@NoArgsConstructor
public class DutyStatusLogSearch extends IdSearch {

  /**
   * The search options which are used to search for duty status log for a device by id.
   *
   * <p>Available DeviceSearch options are:.
   * <ul>
   *    <li>Id</li>
   *    <li>Group</li>
   *    <li>GroupListSearch</li>
   * </ul>
   */
  private DeviceSearch deviceSearch;

  /**
   * The DutyStatusLog logs are searched for events which were recorded on or after this date.
   */
  private LocalDateTime fromDate;

  /**
   * The Fault data logs are searched for events which were recorded on or before this date.
   */
  private LocalDateTime toDate;

  /**
   * Search for {@link DutyStatusLog} with this UserSearch Id or in the provided Groups
   *
   * <p>Available UserSearch options are:.
   * <ul>
   *    <li>Id</li>
   *    <li>GroupSearch</li>
   * </ul>
   */
  private UserSearch userSearch;

  /**
   * Gets or sets search for  DutyStatusLogs and include boundary logs outside the from and to dates (for example, the
   * log immediately preceding the from date).
   */
  private Boolean includeBoundaryLogs;

  /**
   * Gets or sets include modification history of the {@link DutyStatusLog} results.
   */
  private Boolean includeModifications;

  /**
   * Search for DutyStatusLogs with the provided {@link DutyStatusLogType}s.
   */
  private List<DutyStatusLogType> statuses;


  @Builder
  public DutyStatusLogSearch(String id, DeviceSearch deviceSearch, LocalDateTime fromDate,
      LocalDateTime toDate, UserSearch userSearch, Boolean includeBoundaryLogs,
      Boolean includeModifications,
      List<DutyStatusLogType> statuses) {
    super(id);
    this.deviceSearch = deviceSearch;
    this.fromDate = fromDate;
    this.toDate = toDate;
    this.userSearch = userSearch;
    this.includeBoundaryLogs = includeBoundaryLogs;
    this.includeModifications = includeModifications;
    this.statuses = statuses;
  }
}
