/*
 *
 * 2020 Copyright (C) Geotab Inc. All rights reserved.
 */

package com.geotab.model.search;

import com.geotab.model.entity.faultdata.FaultData;
import java.time.LocalDateTime;
import java.util.List;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * The object used to specify the arguments when searching for a {@link FaultData}.
 *
 * <p>This search has been designed to work efficiently with these combinations of parameters:
 * <ul>
 *      <li>
 *             Id
 *     </li>
 *      <li>
 *             DeviceSearch + DiagnosticSearch + FromDate and/or ToDate
 *     </li>
 *      <li>
 *             GroupSearch + DiagnosticSearch + FromDate and/or ToDate
 *     </li>
 * </ul>
 *
 * <p>Cannot be used with DriverGroups.
 */
@Data
@NoArgsConstructor
public class FaultDataSearch extends IdSearch {

  /**
   * The search options which are used to search for fault data for a device by id.
   *
   * <p>Available DeviceSearch options are:.
   * <ul>
   *    <li>id</li>
   * </ul>
   */
  private DeviceSearch deviceSearch;

  /**
   * Search for FaultData recorded for the diagnostic code using the DiagnosticSearch id.
   *
   * <p>Available DiagnosticSearch options are:.
   * <ul>
   *    <li>id</li>
   * </ul>
   */
  private DiagnosticSearch diagnosticSearch;

  /**
   * The FaultData logs are searched for events which were recorded on or after this date.
   */
  private LocalDateTime fromDate;

  /**
   * The Fault data logs are searched for events which were recorded on or before this date.
   */
  private LocalDateTime toDate;

  /**
   * The groups which should be searched.
   *
   * <p>Available GroupSearch options are:.
   * <ul>
   *    <li>id</li>
   * </ul>
   */
  private List<GroupSearch> groups;

  @Builder
  public FaultDataSearch(String id, DeviceSearch deviceSearch,
      DiagnosticSearch diagnosticSearch, LocalDateTime fromDate, LocalDateTime toDate,
      List<GroupSearch> groups) {
    super(id);
    this.deviceSearch = deviceSearch;
    this.diagnosticSearch = diagnosticSearch;
    this.fromDate = fromDate;
    this.toDate = toDate;
    this.groups = groups;
  }
}
