/*
 *
 * 2020 Copyright (C) Geotab Inc. All rights reserved.
 */

package com.geotab.model.search;

import com.geotab.model.entity.fuel.FuelUsed;
import java.time.LocalDateTime;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * The object used to specify the arguments when searching for {@link FuelUsed} elements.
 *
 * <p>This search has been designed to work efficiently with these parameters:
 * <ul>
 *    <li>id</li>
 *    <li>DeviceSearch + FromData and/or ToDate</li>
 * </ul>
 */
@Data
@NoArgsConstructor
public class FuelUsedSearch extends IdSearch {

  /**
   * Filter by the {@link DeviceSearch} options. Providing a device ID will search for any FuelUsed data that are assigned to that Device. Providing
   * the Groups will search for FuelUsed data for that have Devices in that group. Available DeviceSearch options are:
   * <ul>
   *    <li>id</li>
   *    <li>groups</li>
   * </ul>
   */
  private DeviceSearch deviceSearch;

  /**
   * The 'from date', which is used to search for {@link FuelUsed} records recorded on or after this date.
   */
  private LocalDateTime fromDate;

  /**
   * The 'to date', which is used to search for {@link FuelUsed} records recorded on or before this date.
   */
  private LocalDateTime toDate;

  @Builder
  public FuelUsedSearch(String id, DeviceSearch deviceSearch, LocalDateTime fromDate, LocalDateTime toDate) {
    super(id);
    this.deviceSearch = deviceSearch;
    this.fromDate = fromDate;
    this.toDate = toDate;
  }
}
